<?php

namespace Database\Factories;

use App\Models\Tournament;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Bracket>
 */
class BracketFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'tournament_id' => Tournament::factory(),
            'name' => $this->faker->words(2, true),
            'type' => $this->faker->randomElement(['winners', 'losers', 'final']),
            'rounds' => $this->faker->numberBetween(1, 8),
            'structure' => [
                'total_rounds' => $this->faker->numberBetween(1, 8),
                'matches_per_round' => $this->faker->numberBetween(1, 16),
                'seeding_type' => $this->faker->randomElement(['random', 'ranked', 'manual']),
            ],
            'seeding' => [
                'method' => $this->faker->randomElement(['random', 'ranked', 'manual']),
                'players' => $this->faker->numberBetween(8, 64),
            ],
            'is_active' => $this->faker->boolean(),
        ];
    }
}
