# cPanel Cron Job Setup for Laravel Queue Worker

## Your cPanel Cron Job Configuration

### Command to run:
```bash
/home/qtesffgt/themilimus.co.ke php artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

### cPanel Cron Job Settings:

1. **Log into cPanel**
2. **Navigate to "Cron Jobs"**
3. **Add New Cron Job with these settings:**

#### Basic Settings:
- **Common Settings**: Every Minute (* * * * *)
- **Command**: `/home/qtesffgt/themilimus.co.ke php artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600`

#### Alternative Commands (if the above doesn't work):

**Option 1 - Full path to PHP:**
```bash
/usr/local/bin/php /home/qtesffgt/themilimus.co.ke/artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

**Option 2 - With environment file:**
```bash
cd /home/qtesffgt/themilimus.co.ke && php artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

**Option 3 - With full PHP path and environment:**
```bash
cd /home/qtesffgt/themilimus.co.ke && /usr/local/bin/php artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

## Prerequisites for cPanel

### 1. Verify Queue Configuration
Make sure your `.env` file has:
```env
QUEUE_CONNECTION=database
```

### 2. Create Jobs Table
Run these commands via SSH or cPanel Terminal:
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:table
php artisan migrate
```

### 3. Test the Command
Test the command manually first:
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:work --once
```

## cPanel Specific Considerations

### 1. PHP Version
Make sure you're using the correct PHP version. Check your PHP path:
```bash
which php
# or
/usr/local/bin/php -v
```

### 2. Environment File
Ensure your `.env` file is properly configured for production:
```env
APP_ENV=production
APP_DEBUG=false
QUEUE_CONNECTION=database
DB_CONNECTION=mysql
# ... other database settings
```

### 3. File Permissions
Ensure proper permissions:
```bash
chmod 755 /home/qtesffgt/themilimus.co.ke
chmod 755 /home/qtesffgt/themilimus.co.ke/artisan
```

## Monitoring and Troubleshooting

### 1. Check Cron Job Logs
In cPanel, go to "Cron Jobs" and check the "Cron Job Logs" section.

### 2. Test Queue Worker
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:work --once --verbose
```

### 3. Check Failed Jobs
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:failed
```

### 4. Monitor Queue Status
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:work --once
```

## Recommended cPanel Cron Job Settings

### For Production (Every Minute):
```
* * * * * /usr/local/bin/php /home/qtesffgt/themilimus.co.ke/artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

### For Development (Every 5 Minutes):
```
*/5 * * * * /usr/local/bin/php /home/qtesffgt/themilimus.co.ke/artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

## Alternative: Continuous Queue Worker

If you have SSH access, you can run a continuous queue worker instead of cron:

```bash
# Connect via SSH
ssh your-username@themilimus.co.ke

# Navigate to project
cd /home/qtesffgt/themilimus.co.ke

# Start queue worker in background
nohup php artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600 > /dev/null 2>&1 &
```

## Testing the Setup

### 1. Send a Test Notification
Create a test route or use tinker:
```php
// In a test route or tinker
$user = \App\Models\User::first();
$user->notify(new \App\Notifications\User\UserRegisteredNotification($user));
```

### 2. Check if Job is Processed
```bash
cd /home/qtesffgt/themilimus.co.ke
php artisan queue:work --once
```

### 3. Monitor Logs
Check Laravel logs:
```bash
tail -f /home/qtesffgt/themilimus.co.ke/storage/logs/laravel.log
```

## Troubleshooting Common Issues

### Issue 1: Command not found
**Solution**: Use full path to PHP
```bash
/usr/local/bin/php /home/qtesffgt/themilimus.co.ke/artisan queue:work --once
```

### Issue 2: Permission denied
**Solution**: Check file permissions
```bash
chmod 755 /home/qtesffgt/themilimus.co.ke/artisan
```

### Issue 3: Database connection failed
**Solution**: Check `.env` file and database credentials

### Issue 4: Jobs not processing
**Solution**: Check if jobs table exists
```bash
php artisan queue:table
php artisan migrate
```

## Final cPanel Cron Job Command

Use this exact command in cPanel Cron Jobs:

```bash
/usr/local/bin/php /home/qtesffgt/themilimus.co.ke/artisan queue:work --queue=default --timeout=60 --tries=3 --max-jobs=1000 --max-time=3600
```

**Schedule**: Every Minute (* * * * *) 