<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Tournament Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration settings for the tournament system
    |
    */

    
    // Location settings - Global (applies when category restrictions are off)
    'available_countries' => env('TOURNAMENT_COUNTRIES', 'Kenya'),
    'available_counties' => env('TOURNAMENT_COUNTIES', 'Kakamega County,Nairobi County,Mombasa County'),
    
    // Category-specific locations with restrictions
    'category_locations' => array (
  'men' => 
  array (
    'restrict_locations' => true,
    'locations' => 
    array (
      0 => 'Bulovi',
      1 => 'Ivakale',
      2 => 'Shanderema',
      3 => 'Mukhuyu',
      4 => 'Sango',
      5 => 'Kamweka',
      6 => 'Magale',
      7 => 'Igoli',
      8 => 'lukusi',
      9 => 'Tabolwa',
      10 => 'Kuvasali',
      11 => 'Lwanda K and Kambiri Sub location.',
    ),
  ),
  'women' => 
  array (
    'restrict_locations' => false,
    'locations' => 
    array (
    ),
  ),
  'youth_male' => 
  array (
    'restrict_locations' => false,
    'locations' => 
    array (
    ),
  ),
  'youth_female' => 
  array (
    'restrict_locations' => false,
    'locations' => 
    array (
    ),
  ),
  'children' => 
  array (
    'restrict_locations' => false,
    'locations' => 
    array (
    ),
  ),
),

    // Category settings
    'categories' => [
        'men' => [
            'name' => 'Men',
            'age_min' => 18,
            'age_max' => null,
            'gender' => 'male',
            'gender_required' => true,
            'default_fee' => 1000,
            'icon' => '👨',
            'color' => 'blue',
            'description' => 'Men 18 years and above',
        ],
        'women' => [
            'name' => 'Women',
            'age_min' => 18,
            'age_max' => null,
            'gender' => 'female',
            'gender_required' => true,
            'default_fee' => 800,
            'icon' => '👩',
            'color' => 'pink',
            'description' => 'Women 18 years and above',
        ],
        'youth_male' => [
            'name' => 'Youth Male',
            'age_min' => 13,
            'age_max' => 17,
            'gender' => 'male',
            'gender_required' => true,
            'default_fee' => 500,
            'icon' => '🧑',
            'color' => 'purple',
            'description' => 'Male players aged 13-17 years',
        ],
        'youth_female' => [
            'name' => 'Youth Female',
            'age_min' => 13,
            'age_max' => 17,
            'gender' => 'female',
            'gender_required' => true,
            'default_fee' => 500,
            'icon' => '👧',
            'color' => 'purple',
            'description' => 'Female players aged 13-17 years',
        ],
        'children' => [
            'name' => 'Children',
            'age_min' => null,
            'age_max' => 12,
            'gender' => null,
            'gender_required' => false,
            'default_fee' => 300,
            'icon' => '🧒',
            'color' => 'green',
            'description' => 'Children under 13 years (any gender)',
        ],
    ],
]; 