<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Performance Optimization Settings
    |--------------------------------------------------------------------------
    |
    | Configure various performance settings for the application
    |
    */

    'cache' => [
        // Cache driver for optimal performance
        'driver' => env('CACHE_DRIVER', 'redis'),
        
        // Cache TTL in seconds
        'ttl' => env('CACHE_TTL', 3600), // 1 hour default
        
        // Prefixes for different cache types
        'prefixes' => [
            'query' => 'query_',
            'view' => 'view_',
            'route' => 'route_',
            'config' => 'config_',
        ],
    ],

    'database' => [
        // Enable query caching
        'query_cache' => env('DB_QUERY_CACHE', true),
        
        // Query cache TTL in seconds
        'query_cache_ttl' => env('DB_QUERY_CACHE_TTL', 3600),
        
        // Enable eager loading tracking
        'track_n_plus_one' => env('DB_TRACK_N_PLUS_ONE', false),
        
        // Database connection pool size
        'pool_size' => env('DB_POOL_SIZE', 10),
    ],

    'session' => [
        // Use database or redis for sessions
        'driver' => env('SESSION_DRIVER', 'redis'),
        
        // Session lifetime in minutes
        'lifetime' => env('SESSION_LIFETIME', 120),
    ],

    'view' => [
        // Enable view caching
        'cache' => env('VIEW_CACHE', true),
        
        // Minify HTML output
        'minify_html' => env('VIEW_MINIFY_HTML', true),
    ],

    'assets' => [
        // Enable asset versioning
        'versioning' => env('ASSET_VERSIONING', true),
        
        // CDN URL for assets
        'cdn_url' => env('ASSET_CDN_URL', null),
        
        // Enable compression
        'compression' => env('ASSET_COMPRESSION', true),
    ],

    'opcache' => [
        // Enable OPCache
        'enabled' => env('OPCACHE_ENABLED', true),
        
        // Validate timestamps (disable in production)
        'validate_timestamps' => env('OPCACHE_VALIDATE_TIMESTAMPS', false),
        
        // Revalidate frequency
        'revalidate_freq' => env('OPCACHE_REVALIDATE_FREQ', 0),
    ],

    'response' => [
        // Enable GZIP compression
        'gzip' => env('RESPONSE_GZIP', true),
        
        // Compression level (1-9)
        'compression_level' => env('RESPONSE_COMPRESSION_LEVEL', 6),
        
        // Enable HTTP/2 Server Push
        'http2_push' => env('RESPONSE_HTTP2_PUSH', false),
    ],

    'optimization' => [
        // Chunk size for batch processing
        'chunk_size' => env('OPTIMIZATION_CHUNK_SIZE', 1000),
        
        // Enable lazy loading for images
        'lazy_loading' => env('OPTIMIZATION_LAZY_LOADING', true),
        
        // Pagination items per page
        'pagination_items' => env('PAGINATION_ITEMS', 50),
        
        // Max items for select queries
        'max_select_items' => env('MAX_SELECT_ITEMS', 10000),
    ],

];

