<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\User;
use App\Models\Player;
use App\Models\Team;
use App\Models\TeamOfficial;
use App\Models\GameMatch;
use App\Models\Tournament;
use App\Models\Payment;
// use App\Observers\UserObserver;
use App\Observers\PlayerObserver;
use App\Observers\TeamObserver;
use App\Observers\TeamOfficialObserver;
use App\Observers\GameMatchObserver;
use App\Observers\TournamentObserver;
use App\Observers\PaymentObserver;
use Illuminate\Notifications\Channels\MailChannel;
use App\Notifications\Channels\SafeMailChannel;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
	/**
	 * Register any application services.
	 */
	public function register(): void
	{
		// Wrap the default MailChannel with a safe wrapper that swallows transport errors
		$this->app->extend(MailChannel::class, function (MailChannel $mailChannel, $app) {
			return new SafeMailChannel($mailChannel);
		});
	}

	/**
	 * Bootstrap any application services.
	 */
	public function boot(): void
	{
		// Register model observers
		// User::observe(UserObserver::class);
		Schema::defaultStringLength(191);
		Player::observe(PlayerObserver::class);
		// Team::observe(TeamObserver::class);
		TeamOfficial::observe(TeamOfficialObserver::class);
		GameMatch::observe(GameMatchObserver::class);
		Tournament::observe(TournamentObserver::class);
		Payment::observe(PaymentObserver::class);
	}
}
