<?php

namespace App\Notifications\User;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserRoleChangedNotification extends BaseNotification
{
    protected User $user;
    protected string $oldRole;
    protected string $newRole;

    public function __construct(User $user, string $oldRole, string $newRole)
    {
        $this->user = $user;
        $this->oldRole = $oldRole;
        $this->newRole = $newRole;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Role Changed";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your role has been changed.")
            ->line("Previous role: {$this->oldRole}")
            ->line("New role: {$this->newRole}")
            ->line("This change may affect your access permissions.")
            ->line("If you have any questions, please contact support.");
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'user_role_changed',
            'title' => "Role Changed",
            'message' => "Your role has been changed from {$this->oldRole} to {$this->newRole}",
            'user_id' => $this->user->id,
            'old_role' => $this->oldRole,
            'new_role' => $this->newRole,
            'created_at' => now()->toISOString(),
        ];
    }
}