<?php

namespace App\Notifications\User;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserRestoredNotification extends BaseNotification
{
    public function __construct(
        protected User $user
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Account Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your account has been restored successfully.')
            ->action('Go to Dashboard', url('/dashboard'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Account Restored',
            'message' => 'Your account has been restored.',
            'type' => 'user_restored',
            'data' => [
                'user_id' => $this->user->id,
                'user_name' => $this->user->name,
            ],
            'action_url' => url('/dashboard'),
            'action_text' => 'Go to Dashboard',
        ];
    }
} 