<?php

namespace App\Notifications\User;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserProfileUpdatedNotification extends BaseNotification
{
    protected User $user;
    protected array $changes;

    public function __construct(User $user, array $changes)
    {
        $this->user = $user;
        $this->changes = $changes;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Profile Updated Successfully";
        
        $mailMessage = (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your profile has been updated successfully.")
            ->line("Updated fields:");

        foreach ($this->changes as $field => $value) {
            if (!in_array($field, ['password', 'remember_token', 'email_verified_at'])) {
                $mailMessage->line("• " . ucfirst(str_replace('_', ' ', $field)));
            }
        }

        $mailMessage->line("If you didn't make these changes, please contact support immediately.");

        return $mailMessage;
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'user_profile_updated',
            'title' => "Profile Updated",
            'message' => "Your profile has been updated successfully",
            'user_id' => $this->user->id,
            'changes' => array_keys($this->changes),
            'created_at' => now()->toISOString(),
        ];
    }
}