<?php

namespace App\Notifications\User;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserPaymentStatusUpdatedNotification extends BaseNotification
{
    protected User $user;
    protected string $oldStatus;
    protected string $newStatus;

    public function __construct(User $user, string $oldStatus, string $newStatus)
    {
        $this->user = $user;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Payment Status Updated";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your payment status has been updated.")
            ->line("Previous status: {$this->oldStatus}")
            ->line("New status: {$this->newStatus}")
            ->line("This may affect your access to tournament features.");
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'user_payment_status_updated',
            'title' => "Payment Status Updated",
            'message' => "Your payment status has been updated from {$this->oldStatus} to {$this->newStatus}",
            'user_id' => $this->user->id,
            'old_status' => $this->oldStatus,
            'new_status' => $this->newStatus,
            'created_at' => now()->toISOString(),
        ];
    }
}