<?php

namespace App\Notifications\User;

use App\Models\User;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class UserPasswordChangedNotification extends BaseNotification
{
    protected User $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Password Changed Successfully";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your password has been changed successfully.")
            ->line("If you didn't make this change, please contact support immediately and secure your account.")
            ->line("For security reasons, you may need to log in again on all devices.");
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'user_password_changed',
            'title' => "Password Changed",
            'message' => "Your password has been changed successfully",
            'user_id' => $this->user->id,
            'created_at' => now()->toISOString(),
        ];
    }
}