<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentVenueChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldVenue = null,
        protected ?string $newVenue = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Venue Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The venue for tournament ' . ($this->tournamentName ?? '') . ' has changed.')
            ->line('Old venue: ' . ($this->oldVenue ?? 'N/A'))
            ->line('New venue: ' . ($this->newVenue ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Venue Changed',
            'message' => 'The venue for tournament ' . ($this->tournamentName ?? '') . ' has changed from ' . ($this->oldVenue ?? 'N/A') . ' to ' . ($this->newVenue ?? 'N/A') . '.',
            'type' => 'tournament_venue_changed',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_venue' => $this->oldVenue,
                'new_venue' => $this->newVenue,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
