<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentStreamingAnnouncedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $streamingUrl = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Streaming Announced')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Great news! Tournament ' . ($this->tournamentName ?? '') . ' will be streamed live.')
            ->line('Streaming URL: ' . ($this->streamingUrl ?? 'TBA'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Streaming Announced',
            'message' => 'Great news! Tournament ' . ($this->tournamentName ?? '') . ' will be streamed live at ' . ($this->streamingUrl ?? 'TBA') . '.',
            'type' => 'tournament_streaming_announced',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'streaming_url' => $this->streamingUrl,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
