<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentStatusChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldStatus = null,
        protected ?string $newStatus = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Status Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The status of tournament ' . ($this->tournamentName ?? '') . ' has changed.')
            ->line('Old status: ' . ($this->oldStatus ?? 'N/A'))
            ->line('New status: ' . ($this->newStatus ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Status Changed',
            'message' => 'The status of tournament ' . ($this->tournamentName ?? '') . ' has changed from ' . ($this->oldStatus ?? 'N/A') . ' to ' . ($this->newStatus ?? 'N/A') . '.',
            'type' => 'tournament_status_changed',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_status' => $this->oldStatus,
                'new_status' => $this->newStatus,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
