<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentStartedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Started')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Tournament ' . ($this->tournamentName ?? '') . ' has officially started!')
            ->line('Good luck to all participants.')
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Started',
            'message' => 'Tournament ' . ($this->tournamentName ?? '') . ' has officially started! Good luck to all participants.',
            'type' => 'tournament_started',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}