<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRulesUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Rules Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The rules for tournament ' . ($this->tournamentName ?? '') . ' have been updated.')
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Rules Updated',
            'message' => 'The rules for tournament ' . ($this->tournamentName ?? '') . ' have been updated.',
            'type' => 'tournament_rules_updated',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
