<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRestoredNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Tournament ' . ($this->tournamentName ?? '') . ' has been restored.')
            ->action('View Tournaments', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Restored',
            'message' => 'Tournament ' . ($this->tournamentName ?? '') . ' has been restored.',
            'type' => 'tournament_restored',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournaments',
        ];
    }
}
