<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRegistrationOpenedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Registration Opened')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Registration for tournament ' . ($this->tournamentName ?? '') . ' is now open!')
            ->line('Don\'t miss out on this exciting opportunity.')
            ->action('Register Now', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Registration Opened',
            'message' => 'Registration for tournament ' . ($this->tournamentName ?? '') . ' is now open! Don\'t miss out on this exciting opportunity.',
            'type' => 'tournament_registration_opened',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'Register Now',
        ];
    }
}