<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRegistrationDatesChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldRegistrationDates = null,
        protected ?string $newRegistrationDates = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Registration Dates Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The registration dates for tournament ' . ($this->tournamentName ?? '') . ' have changed.')
            ->line('Old registration dates: ' . ($this->oldRegistrationDates ?? 'N/A'))
            ->line('New registration dates: ' . ($this->newRegistrationDates ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Registration Dates Changed',
            'message' => 'The registration dates for tournament ' . ($this->tournamentName ?? '') . ' have changed from ' . ($this->oldRegistrationDates ?? 'N/A') . ' to ' . ($this->newRegistrationDates ?? 'N/A') . '.',
            'type' => 'tournament_registration_dates_changed',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_registration_dates' => $this->oldRegistrationDates,
                'new_registration_dates' => $this->newRegistrationDates,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
