<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentRefundEligibleNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $amount = null,
        protected ?string $currency = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Refund Eligible')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You are eligible for a refund for tournament ' . ($this->tournamentName ?? ''))
            ->line('Amount: ' . (($this->currency ?? '') . ' ' . ($this->amount ?? '')))
            ->action('Contact Support', url('/contact'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Refund Eligible',
            'message' => 'Refund eligible for ' . ($this->tournamentName ?? ''),
            'type' => 'tournament_refund_eligible',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'amount' => $this->amount,
                'currency' => $this->currency,
            ],
            'action_url' => url('/contact'),
            'action_text' => 'Contact Support',
        ];
    }
}
