<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentPublishedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Published')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Tournament ' . ($this->tournamentName ?? '') . ' has been published and is now live.')
            ->line('Players can now register for this tournament.')
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Published',
            'message' => 'Tournament ' . ($this->tournamentName ?? '') . ' has been published and is now live for registration.',
            'type' => 'tournament_published',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
