<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentPrizePoolUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldPrizePool = null,
        protected ?string $newPrizePool = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Prize Pool Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The prize pool for tournament ' . ($this->tournamentName ?? '') . ' has been updated.')
            ->line('Old prize pool: ' . ($this->oldPrizePool ?? 'N/A'))
            ->line('New prize pool: ' . ($this->newPrizePool ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Prize Pool Updated',
            'message' => 'The prize pool for tournament ' . ($this->tournamentName ?? '') . ' has been updated from ' . ($this->oldPrizePool ?? 'N/A') . ' to ' . ($this->newPrizePool ?? 'N/A') . '.',
            'type' => 'tournament_prize_pool_updated',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_prize_pool' => $this->oldPrizePool,
                'new_prize_pool' => $this->newPrizePool,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
