<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentFeaturedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Featured')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Congratulations! Tournament ' . ($this->tournamentName ?? '') . ' has been featured.')
            ->line('This means your tournament will receive special promotion and visibility.')
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Featured',
            'message' => 'Congratulations! Tournament ' . ($this->tournamentName ?? '') . ' has been featured and will receive special promotion.',
            'type' => 'tournament_featured',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
