<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentEntryFeeUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldEntryFee = null,
        protected ?string $newEntryFee = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Entry Fee Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The entry fee for tournament ' . ($this->tournamentName ?? '') . ' has been updated.')
            ->line('Old entry fee: ' . ($this->oldEntryFee ?? 'N/A'))
            ->line('New entry fee: ' . ($this->newEntryFee ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Entry Fee Updated',
            'message' => 'The entry fee for tournament ' . ($this->tournamentName ?? '') . ' has been updated from ' . ($this->oldEntryFee ?? 'N/A') . ' to ' . ($this->newEntryFee ?? 'N/A') . '.',
            'type' => 'tournament_entry_fee_updated',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_entry_fee' => $this->oldEntryFee,
                'new_entry_fee' => $this->newEntryFee,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
