<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentDeletedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Deleted')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Tournament ' . ($this->tournamentName ?? '') . ' has been deleted.')
            ->action('View Tournaments', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Deleted',
            'message' => 'Tournament ' . ($this->tournamentName ?? '') . ' has been deleted.',
            'type' => 'tournament_deleted',
            'data' => [
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournaments',
        ];
    }
}
