<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TournamentDatesChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $tournamentName = null,
        protected ?string $oldDates = null,
        protected ?string $newDates = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Tournament Dates Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The dates for tournament ' . ($this->tournamentName ?? '') . ' have changed.')
            ->line('Old dates: ' . ($this->oldDates ?? 'N/A'))
            ->line('New dates: ' . ($this->newDates ?? 'N/A'))
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Tournament Dates Changed',
            'message' => 'The dates for tournament ' . ($this->tournamentName ?? '') . ' have changed from ' . ($this->oldDates ?? 'N/A') . ' to ' . ($this->newDates ?? 'N/A') . '.',
            'type' => 'tournament_dates_changed',
            'data' => [
                'tournament_name' => $this->tournamentName,
                'old_dates' => $this->oldDates,
                'new_dates' => $this->newDates,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
