<?php

namespace App\Notifications\User;

use App\Models\Team;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamUpdatedNotification extends BaseNotification
{
    protected Team $team;
    protected array $changes;

    public function __construct(Team $team, array $changes)
    {
        $this->team = $team;
        $this->changes = $changes;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Team Updated: {$this->team->name}";
        
        $mailMessage = (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your team '{$this->team->name}' has been updated.")
            ->line("Updated fields:");

        foreach ($this->changes as $field => $value) {
            $mailMessage->line("• " . ucfirst(str_replace('_', ' ', $field)));
        }

        $mailMessage->action('View Team Details', route('teams.show', $this->team));

        return $mailMessage;
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'team_updated',
            'title' => "Team Updated",
            'message' => "Team '{$this->team->name}' has been updated",
            'team_id' => $this->team->id,
            'team_name' => $this->team->name,
            'changes' => array_keys($this->changes),
            'action_url' => route('teams.show', $this->team),
            'created_at' => now()->toISOString(),
        ];
    }
}