<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamTournamentRegisteredNotification extends BaseNotification
{
    public function __construct(
        protected ?string $teamName = null,
        protected ?string $tournamentName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Registered for Tournament')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your team ' . ($this->teamName ?? '') . ' has been successfully registered for tournament ' . ($this->tournamentName ?? '') . '.')
            ->line('Good luck in the competition!')
            ->action('View Tournament', url('/frontend/tournaments'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Registered for Tournament',
            'message' => 'Your team ' . ($this->teamName ?? '') . ' has been successfully registered for tournament ' . ($this->tournamentName ?? '') . '.',
            'type' => 'team_tournament_registered',
            'data' => [
                'team_name' => $this->teamName,
                'tournament_name' => $this->tournamentName,
            ],
            'action_url' => url('/frontend/tournaments'),
            'action_text' => 'View Tournament',
        ];
    }
}
