<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamRestoredNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Team ' . ($this->teamName ?? '') . ' has been restored.')
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Restored',
            'message' => 'Team ' . ($this->teamName ?? '') . ' has been restored.',
            'type' => 'team_restored',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
