<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamRestoredMemberNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $memberName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Member Restored')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line(($this->memberName ?? 'A member') . ' has been restored to team ' . ($this->teamName ?? ''))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Member Restored',
            'message' => ($this->memberName ?? 'A member') . ' restored to ' . ($this->teamName ?? ''),
            'type' => 'team_member_restored',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'member_name' => $this->memberName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
