<?php

namespace App\Notifications\User;

use App\Models\Player;
use App\Models\Team;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamPlayerRemovedNotification extends BaseNotification
{
    public function __construct(
        protected Player $player,
        protected Team $team
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Player Removed from Team "' . ($this->team->name ?? 'Team') . '"')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A player has been removed from your team "' . ($this->team->name ?? 'Team') . '".')
            ->line('Player: ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown'))
            ->line('Tournament: ' . ($this->player->tournament->name ?? ''))
            ->action('View Team Profile', url('/player/profile'))
            ->line('Your team roster has been updated.');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Player Removed from Team',
            'message' => 'Player ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown') . ' was removed from team "' . ($this->team->name ?? 'Team') . '" in ' . ($this->player->tournament->name ?? ''),
            'type' => 'player_removed',
            'data' => [
                'player_id' => $this->player->id,
                'player_name' => $this->player->display_name ?? $this->player->user->name ?? 'Unknown',
                'team_id' => $this->team->id,
                'team_name' => $this->team->name ?? 'Team',
                'tournament_id' => $this->player->tournament->id ?? null,
                'tournament_name' => $this->player->tournament->name ?? '',
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
