<?php

namespace App\Notifications\User;

use App\Models\Player;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamPlayerAddedNotification extends BaseNotification
{
    public function __construct(
        protected Player $player
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('New Player Added to Team "' . ($this->player->team->name ?? 'Team') . '"')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('A new player has been added to your team "' . ($this->player->team->name ?? 'Team') . '".')
            ->line('Player: ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown'))
            ->line('Tournament: ' . ($this->player->tournament->name ?? ''))
            ->action('View Team Profile', url('/player/profile'))
            ->line('Your team is growing!');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'New Player Added to Team',
            'message' => 'Player ' . ($this->player->display_name ?? $this->player->user->name ?? 'Unknown') . ' was added to team "' . ($this->player->team->name ?? 'Team') . '" in ' . ($this->player->tournament->name ?? ''),
            'type' => 'player_added',
            'data' => [
                'player_id' => $this->player->id,
                'player_name' => $this->player->display_name ?? $this->player->user->name ?? 'Unknown',
                'team_id' => $this->player->team->id ?? null,
                'team_name' => $this->player->team->name ?? 'Team',
                'tournament_id' => $this->player->tournament->id ?? null,
                'tournament_name' => $this->player->tournament->name ?? '',
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team Profile',
        ];
    }
}
