<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamPaymentCompletedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $amount = null,
        protected ?string $currency = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Payment Completed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your team payment has been completed successfully.')
            ->line('Team: ' . ($this->teamName ?? ''))
            ->line('Amount: ' . (($this->currency ?? '') . ' ' . ($this->amount ?? '')))
            ->action('View Team', url('/admin/teams/' . ($this->teamId ?? '')));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Payment Completed',
            'message' => 'Team ' . ($this->teamName ?? '') . ' payment has been completed.',
            'type' => 'team_payment_completed',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'amount' => $this->amount,
                'currency' => $this->currency,
            ],
            'action_url' => url('/admin/teams/' . ($this->teamId ?? '')),
            'action_text' => 'View Team',
        ];
    }
}
