<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialRoleChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $oldRole = null,
        protected ?string $newRole = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Role Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your official role on team ' . ($this->teamName ?? '') . ' has changed.')
            ->line('Previous role: ' . ($this->oldRole ?? ''))
            ->line('New role: ' . ($this->newRole ?? ''))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Role Changed',
            'message' => 'Your official role has changed on ' . ($this->teamName ?? ''),
            'type' => 'official_role_changed',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'old_role' => $this->oldRole,
                'new_role' => $this->newRole,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
