<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialRestoredNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $role = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Restored on Team')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your official role has been restored on team ' . ($this->teamName ?? ''))
            ->line('Role: ' . ($this->role ?? 'Official'))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Restored',
            'message' => 'Your official role has been restored on ' . ($this->teamName ?? ''),
            'type' => 'official_restored',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
