<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialRemovedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $role = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Removed from Team Official Role')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been removed from an official role on team ' . ($this->teamName ?? ''))
            ->line('Role: ' . ($this->role ?? 'Official'))
            ->action('View Teams', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Role Removed',
            'message' => 'You have been removed from the role of ' . ($this->role ?? 'Official') . ' on ' . ($this->teamName ?? ''),
            'type' => 'official_removed',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Teams',
        ];
    }
}
