<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialQualificationsUpdatedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $role = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Qualifications Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Your official qualifications have been updated for team ' . ($this->teamName ?? ''))
            ->line('Role: ' . ($this->role ?? 'Official'))
            ->action('View Profile', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Qualifications Updated',
            'message' => 'Your official qualifications have been updated for ' . ($this->teamName ?? ''),
            'type' => 'official_qualifications_updated',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Profile',
        ];
    }
}
