<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialAssignedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $role = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Assigned to Team')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been assigned as an official to team ' . ($this->teamName ?? ''))
            ->line('Role: ' . ($this->role ?? 'Official'))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Assigned',
            'message' => 'You have been assigned as ' . ($this->role ?? 'Official') . ' to ' . ($this->teamName ?? ''),
            'type' => 'official_assigned',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
