<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamOfficialAddedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $role = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Official Added to Team')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been added as an official to the team ' . ($this->teamName ?? ''))
            ->line('Role: ' . ($this->role ?? 'Official'))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Official Added to Team',
            'message' => 'You have been added as ' . ($this->role ?? 'Official') . ' to ' . ($this->teamName ?? ''),
            'type' => 'official_added',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'role' => $this->role,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
