<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamNewMemberNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $memberName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('New Team Member')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line(($this->memberName ?? 'A member') . ' has joined team ' . ($this->teamName ?? ''))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'New Team Member',
            'message' => ($this->memberName ?? 'A member') . ' joined ' . ($this->teamName ?? ''),
            'type' => 'team_new_member',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'member_name' => $this->memberName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
