<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamMemberWelcomeNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Welcome to the Team')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Welcome to ' . ($this->teamName ?? 'the team') . '!')
            ->line('We are excited to have you on board.')
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Welcome to the Team',
            'message' => 'Welcome to ' . ($this->teamName ?? 'the team') . '!',
            'type' => 'team_member_welcome',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
