<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamMaxPlayersChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $teamName = null,
        protected ?int $oldMax = null,
        protected ?int $newMax = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Maximum Players Updated')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The maximum players for ' . ($this->teamName ?? '') . ' has changed.')
            ->line('Previous max: ' . ($this->oldMax ?? 'N/A'))
            ->line('New max: ' . ($this->newMax ?? 'N/A'))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Max Players Updated',
            'message' => 'Max players changed for ' . ($this->teamName ?? ''),
            'type' => 'team_max_players_changed',
            'data' => [
                'team_name' => $this->teamName,
                'old_max' => $this->oldMax,
                'new_max' => $this->newMax,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
