<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamDeletedNotification extends BaseNotification
{
    public function __construct(
        protected ?string $teamName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Deleted')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Team ' . ($this->teamName ?? '') . ' has been deleted.')
            ->action('View Teams', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Deleted',
            'message' => 'Team ' . ($this->teamName ?? '') . ' has been deleted.',
            'type' => 'team_deleted',
            'data' => [
                'team_name' => $this->teamName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Teams',
        ];
    }
}
