<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamDeletedMemberNotification extends BaseNotification
{
    public function __construct(
        protected ?string $memberName = null,
        protected ?string $teamName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Member Removed (Team Deleted)')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('Team ' . ($this->teamName ?? '') . ' was deleted. Member ' . ($this->memberName ?? '') . ' is no longer in the team.')
            ->action('View Teams', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Deleted - Member Removed',
            'message' => 'Team ' . ($this->teamName ?? '') . ' was deleted. ' . ($this->memberName ?? 'A member') . ' removed.',
            'type' => 'team_deleted_member',
            'data' => [
                'team_name' => $this->teamName,
                'member_name' => $this->memberName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Teams',
        ];
    }
}
