<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCaptainRemovedNotification extends BaseNotification
{
    /**
     * Create a new notification instance.
     */
    public function __construct(
        protected Player $player
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Captain Removed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('You have been removed as the captain of team "' . ($this->player->team->name ?? 'Team') . '".')
            ->line('Tournament: ' . ($this->player->tournament->name ?? ''))
            ->action('View Team Profile', url('/player/profile'))
            ->line('You are no longer the team captain.');
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('/'))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
