<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCaptainInvitationNotification extends BaseNotification
{
    protected $invitationData;

    public function __construct(array $invitationData)
    {
        $this->invitationData = $invitationData;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Captain Invitation - ' . $this->invitationData['team_name'])
            ->greeting('Hello ' . $notifiable->name . '!')
            ->line('You have been invited to become the team captain for a new team registration.')
            ->line('Team Details:')
            ->line('• Team Name: ' . $this->invitationData['team_name'])
            ->line('• Tournament: ' . $this->invitationData['tournament_name'])
            ->line('• Registration Details:')
            ->line('  - Name: ' . $this->invitationData['name'])
            ->line('  - Phone: ' . $this->invitationData['phone'])
            ->line('• Invitation Date: ' . now()->format('F j, Y g:i A'))
            ->line('Someone tried to register this team using your email address.')
            ->line('If you want to accept this team captain role, please log in to your account.')
            ->line('If you did not initiate this registration, please contact our support team immediately.')
            ->action('Login to Your Account', url('/login'))
            ->line('You can accept or decline this invitation from your dashboard.')
            ->line('Thank you for your attention to this matter.')
            ->salutation('Best regards, Tournament Management Team');
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Captain Invitation - ' . $this->invitationData['team_name'],
            'message' => 'You have been invited to become team captain for ' . $this->invitationData['team_name'] . ' in ' . $this->invitationData['tournament_name'],
            'type' => 'team_captain_invitation',
            'data' => [
                'team_name' => $this->invitationData['team_name'],
                'tournament_name' => $this->invitationData['tournament_name'],
                'registration_details' => [
                    'name' => $this->invitationData['name'],
                    'phone' => $this->invitationData['phone'],
                ],
                'invitation_date' => now()->toISOString(),
                'status' => 'pending', // pending, accepted, declined
            ],
            'action_url' => url('/login'),
            'action_text' => 'Login to Respond',
            'priority' => 'high',
            'category' => 'team_invitation',
        ];
    }
}
