<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCaptainChangedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $oldCaptain = null,
        protected ?string $newCaptain = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Captain Changed')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line('The team captain has changed for team ' . ($this->teamName ?? ''))
            ->line('Previous captain: ' . ($this->oldCaptain ?? 'N/A'))
            ->line('New captain: ' . ($this->newCaptain ?? 'N/A'))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Captain Changed',
            'message' => 'Captain changed for ' . ($this->teamName ?? ''),
            'type' => 'team_captain_changed',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'old_captain' => $this->oldCaptain,
                'new_captain' => $this->newCaptain,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
