<?php

namespace App\Notifications\User;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class TeamCaptainAssignedNotification extends BaseNotification
{
    public function __construct(
        protected ?int $teamId = null,
        protected ?string $teamName = null,
        protected ?string $captainName = null
    ) {}

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Team Captain Assigned')
            ->greeting('Hello ' . ($notifiable->name ?? ''))
            ->line(($this->captainName ?? 'A user') . ' has been assigned as captain of team ' . ($this->teamName ?? ''))
            ->action('View Team', url('/player/profile'));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'title' => 'Team Captain Assigned',
            'message' => ($this->captainName ?? 'A user') . ' has been assigned as captain of ' . ($this->teamName ?? ''),
            'type' => 'team_captain_assigned',
            'data' => [
                'team_id' => $this->teamId,
                'team_name' => $this->teamName,
                'captain_name' => $this->captainName,
            ],
            'action_url' => url('/player/profile'),
            'action_text' => 'View Team',
        ];
    }
}
