<?php

namespace App\Notifications\User;

use App\Models\Player;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class PlayerVerificationUpdatedNotification extends BaseNotification
{
    protected Player $player;
    protected string $verificationStatus;

    public function __construct(Player $player, string $verificationStatus)
    {
        $this->player = $player;
        $this->verificationStatus = $verificationStatus;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Player Verification Updated";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your player verification status has been updated.")
            ->line("Player: {$this->player->name}")
            ->line("Verification Status: {$this->verificationStatus}")
            ->line("This may affect your tournament participation.")
            ->action('View Player Profile', route('players.show', $this->player));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'player_verification_updated',
            'title' => "Player Verification Updated",
            'message' => "Verification status for {$this->player->name} updated to {$this->verificationStatus}",
            'player_id' => $this->player->id,
            'player_name' => $this->player->name,
            'verification_status' => $this->verificationStatus,
            'action_url' => route('players.show', $this->player),
            'created_at' => now()->toISOString(),
        ];
    }
} 