<?php

namespace App\Notifications\User;

use App\Models\Player;
use App\Models\Tournament;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class PlayerTournamentRegisteredNotification extends BaseNotification
{
    protected Player $player;
    protected Tournament $tournament;

    public function __construct(Player $player, Tournament $tournament)
    {
        $this->player = $player;
        $this->tournament = $tournament;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Tournament Registration Confirmed: {$this->tournament->name}";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your player registration for a tournament has been confirmed.")
            ->line("Player: {$this->player->name}")
            ->line("Tournament: {$this->tournament->name}")
            ->line("Registration Date: " . now()->format('F j, Y'))
            ->line("Tournament Dates: {$this->tournament->start_date->format('F j, Y')} - {$this->tournament->end_date->format('F j, Y')}")
            ->action('View Tournament', route('tournaments.show', $this->tournament));
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'type' => 'player_tournament_registered',
            'title' => "Tournament Registration Confirmed",
            'message' => "Player {$this->player->name} registered for {$this->tournament->name}",
            'player_id' => $this->player->id,
            'player_name' => $this->player->name,
            'tournament_id' => $this->tournament->id,
            'tournament_name' => $this->tournament->name,
            'action_url' => route('tournaments.show', $this->tournament),
            'created_at' => now()->toISOString(),
        ];
    }
}
