<?php

namespace App\Notifications\User;

use App\Models\Player;
use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;

class PlayerStatusChangedNotification extends BaseNotification
{
    protected Player $player;
    protected string $oldStatus;
    protected string $newStatus;

    public function __construct(Player $player, string $oldStatus, string $newStatus)
    {
        $this->player = $player;
        $this->oldStatus = $oldStatus;
        $this->newStatus = $newStatus;
    }

    protected function buildMailMessage(object $notifiable): MailMessage
    {
        $subject = "Player Status Updated";
        
        return (new MailMessage)
            ->subject($subject)
            ->greeting("Hello {$notifiable->name},")
            ->line("Your player status has been updated.")
            ->line("Previous status: {$this->oldStatus}")
            ->line("New status: {$this->newStatus}")
            ->line("This may affect your tournament participation.")
            ->action('View Player Profile', route('players.show', $this->player));
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'player_status_changed',
            'title' => "Player Status Updated",
            'message' => "Your player status has been changed from {$this->oldStatus} to {$this->newStatus}",
            'player_id' => $this->player->id,
            'old_status' => $this->oldStatus,
            'new_status' => $this->newStatus,
            'action_url' => route('players.show', $this->player),
            'created_at' => now()->toISOString(),
        ];
    }
}